// created by jay 1.1.0 (c) 2002-2006 ats@cs.rit.edu
// skeleton Java tables 1.1.0 (c) 2002-2006 ats@cs.rit.edu

					// line 2 "MiniParser.jay"
//
// $Id: MiniParser.jay,v 2.13.2.1 2013/03/14 10:25:30 ronald Exp $
//
// Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
//
//
//

package de.independit.scheduler.shell;

import java.io.*;
import java.util.*;
import java.lang.*;
import java.util.regex.*;
import de.independit.scheduler.server.util.*;
import de.independit.scheduler.server.exception.*;
import de.independit.scheduler.server.output.*;

public class MiniParser 
{

	private int stop = 0;
	private boolean discOnError = false;
	private int retVal = 0;
	private static boolean printTime = false;
	private static boolean printCmd = true;

	private SDMSServerConnection sc = null;
	private SDMSOutputRenderer or = null;
	private String host;
	private String port;
	private String user;

	private PrintStream out = System.out;

	private boolean isDump = false;

	private static final String S_SYNTAX_ERROR = "Syntax Error";

	private static int stmtCtr = 0;
	private static Vector stmtList = new Vector();

					// line 48 "-"
  // %token constants
  public static final int DISCONNECT = 257;
  public static final int S_ERROR = 258;
  public static final int WHENEVER = 259;
  public static final int CONTINUE = 260;
  public static final int HELP = 261;
  public static final int PROMPT = 262;
  public static final int EOS = 263;
  public static final int INTEGER = 264;
  public static final int NAN = 265;
  public static final int BMULTI = 266;
  public static final int EMULTI = 267;
  public static final int ECHOOFF = 268;
  public static final int ECHOON = 269;
  public static final int FILENOTFOUND = 270;
  public static final int FILESPEC = 271;
  public static final int INVALIDFILE = 272;
  public static final int ROLLBACK = 273;
  public static final int SHELLCMD = 274;
  public static final int STATEMENT = 275;
  public static final int STRING = 276;
  public static final int TIMINGON = 277;
  public static final int TIMINGOFF = 278;
  public static final int yyErrorCode = 256;

  /** number of final states.
  */
  protected static final int yyFinal = 1;

  /** parser tables.
      Cannot be <tt>final</tt> because they are loaded from a resource.
      Order is mandated by <i>jay</i>.
  */
  protected static short[] yyLhs, yyLen, yyDefRed, yyDgoto,
  	yySindex, yyRindex, yyGindex, yyTable, yyCheck;

//yyLhs 35
//yy    -1,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     7,     2,     2,     5,
//yy     3,     3,     4,     4,     6,     9,     9,     1,     1,     8,
//yy     8,     8,     8,     8,     8,
//yyLen 35
//yy     2,     0,     2,     2,     2,     2,     2,     2,     2,     2,
//yy     2,     2,     2,     2,     2,     2,     5,     0,     1,     2,
//yy     0,     1,     1,     2,     3,     2,     1,     1,     1,     1,
//yy     1,     1,     1,     1,     1,
//yyDefRed 41
//yy     1,     0,     3,    29,     0,    30,    10,     0,    31,    32,
//yy     0,    33,    12,    11,     5,    34,     6,     7,     2,    13,
//yy    14,    15,     4,     8,     9,     0,    19,    22,     0,     0,
//yy     0,    26,    24,     0,    23,    27,    28,    25,    18,     0,
//yy    16,
//yyDgoto 10
//yy     1,    37,    39,    28,    29,    21,    22,    23,    24,    32,
//yySindex 41
//yy     0,  -257,     0,     0,  -252,     0,     0,  -251,     0,     0,
//yy  -249,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,  -241,     0,     0,  -243,  -248,
//yy  -242,     0,     0,  -245,     0,     0,     0,     0,     0,  -234,
//yy     0,
//yyRindex 41
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy  -237,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,  -236,
//yy     0,     0,     0,  -231,     0,     0,     0,     0,     0,     0,
//yy     0,
//yyGindex 10
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yyTable 33
//yy     2,     3,     4,     5,     6,     7,    25,     8,     9,    10,
//yy    11,    12,    13,    14,    15,    16,    30,    17,    18,    31,
//yy    19,    20,    35,    36,    33,    26,    27,    34,    38,    40,
//yy    20,    21,    17,
//yyCheck 33
//yy   257,   258,   259,   260,   261,   262,   258,   264,   265,   266,
//yy   267,   268,   269,   270,   271,   272,   257,   274,   275,   260,
//yy   277,   278,   264,   265,   267,   276,   275,   275,   273,   263,
//yy   267,   267,   263,

  /** maps symbol value to printable name.
  		@see #yyExpecting
  	*/
  protected static String[] yyNames;
//yyNames 279 23
//yy 0 end-of-file
//yy 257 DISCONNECT
//yy 258 S_ERROR
//yy 259 WHENEVER
//yy 260 CONTINUE
//yy 261 HELP
//yy 262 PROMPT
//yy 263 EOS
//yy 264 INTEGER
//yy 265 NAN
//yy 266 BMULTI
//yy 267 EMULTI
//yy 268 ECHOOFF
//yy 269 ECHOON
//yy 270 FILENOTFOUND
//yy 271 FILESPEC
//yy 272 INVALIDFILE
//yy 273 ROLLBACK
//yy 274 SHELLCMD
//yy 275 STATEMENT
//yy 276 STRING
//yy 277 TIMINGON
//yy 278 TIMINGOFF

//t  /** printable rules for debugging.
//t  	*/
//t  protected static String[] yyRule;
//t
//yyRule 35
//yy $accept: cmdlist
//yy cmdlist:
//yy cmdlist: cmdlist STATEMENT
//yy cmdlist: cmdlist DISCONNECT
//yy cmdlist: cmdlist whenever
//yy cmdlist: cmdlist FILENOTFOUND
//yy cmdlist: cmdlist INVALIDFILE
//yy cmdlist: cmdlist SHELLCMD
//yy cmdlist: cmdlist multicmd
//yy cmdlist: cmdlist errtok
//yy cmdlist: cmdlist HELP
//yy cmdlist: cmdlist ECHOON
//yy cmdlist: cmdlist ECHOOFF
//yy cmdlist: cmdlist TIMINGON
//yy cmdlist: cmdlist TIMINGOFF
//yy cmdlist: cmdlist prompt
//yy multicmd: BMULTI opt_stmtlist EMULTI opt_rollback EOS
//yy opt_rollback:
//yy opt_rollback: ROLLBACK
//yy prompt: PROMPT STRING
//yy opt_stmtlist:
//yy opt_stmtlist: stmtlist
//yy stmtlist: STATEMENT
//yy stmtlist: stmtlist STATEMENT
//yy whenever: WHENEVER S_ERROR action
//yy action: DISCONNECT integer
//yy action: CONTINUE
//yy integer: INTEGER
//yy integer: NAN
//yy errtok: S_ERROR
//yy errtok: CONTINUE
//yy errtok: INTEGER
//yy errtok: NAN
//yy errtok: EMULTI
//yy errtok: FILESPEC

  /** loads parser table.
  		Format: name length newline ten-numbers newline ...
  	*/
  protected static short[] loadShort (java.io.BufferedReader in)
  	throws Exception
  {
  	java.util.StringTokenizer st = new java.util.StringTokenizer(in.readLine());
  	st.nextToken();
  	short[] result = new short[Integer.parseInt(st.nextToken())];
  	for (int n = 0; n < result.length; n += 10) {
  		st = new java.util.StringTokenizer(in.readLine(), ", \t\r\n");
  		for (int m = 0; st.hasMoreTokens(); ++ m)
  			result[n+m] = Short.valueOf(st.nextToken()).shortValue();
  	}
  	return result;
  }

  // once-only code to initialize parser tables
  // non-static to name resource after parser class
  // any error is fatal
  {
  	if (yyLhs == null)
  		try {
  			Class myClass = getClass();
  			String resource = myClass.getPackage().getName().replace('.', '/')+"/parser.tables";
//t  			System.out.println("Trying to load tables from " + resource);
  			java.io.InputStream i;
  			try { // full path in jar file
  				i = myClass.getResourceAsStream("/"+resource);
  			} catch (Exception e) { // relative path
  				i = myClass.getResourceAsStream(resource);
  			}
  			java.io.BufferedReader in =
  				new java.io.BufferedReader(new java.io.InputStreamReader(i));
  
  			yyLhs = loadShort(in);
  			yyLen = loadShort(in);
  			yyDefRed = loadShort(in);
  			yyDgoto = loadShort(in);
  			yySindex = loadShort(in);
  			yyRindex = loadShort(in);
  			yyGindex = loadShort(in);
  			yyTable = loadShort(in);
  			yyCheck = loadShort(in);
  
  			// load name table
  			// Format: yyNames length lines newline index space name newline ...for lines
  			{ java.util.StringTokenizer st = new java.util.StringTokenizer(in.readLine());
  				st.nextToken();
  				yyNames = new String[Integer.parseInt(st.nextToken())];
  				int max = Integer.parseInt(st.nextToken());
  				for (int n = 0; n < max; ++ n) {
  					st = new java.util.StringTokenizer(in.readLine());
  					int m = Integer.parseInt(st.nextToken());
  					yyNames[m] = st.nextToken("\n").substring(1);
  				}
  			}
  
//t  			// load rules table for debugging
//t  			// Format: yyRule length newline rule newline ...for length
//t  			{ java.util.StringTokenizer st = new java.util.StringTokenizer(in.readLine());
//t  				st.nextToken();
//t  				yyRule = new String[Integer.parseInt(st.nextToken())];
//t  				for (int n = 0; n < yyRule.length; ++ n)
//t  					yyRule[n] = in.readLine();
//t  			}
  
  			in.close();
  		} catch (Exception e) {
  			throw new Error("cannot load parser tables ["+e+"]");
  		}
  }

//t  /** debugging support, requires the package <tt>jay.yydebug</tt>.
//t      Set to <tt>null</tt> to suppress debugging messages.
//t  */
//t  protected jay.yydebug.yyDebug yydebug;
//t
//t  /** index-checked interface to {@link #yyNames}.
//t      @param token single character or <tt>%token</tt> value.
//t      @return token name or <tt>[illegal]</tt> or <tt>[unknown]</tt>.
//t  */
//t  public static final String yyName (int token)
//t  {
//t  	if (token < 0 || token > yyNames.length) return "[illegal]";
//t  	String name;
//t  	if ((name = yyNames[token]) != null) return name;
//t  	return "[unknown]";
//t  }
//t
  /** thrown for irrecoverable syntax errors and stack overflow.
      Nested for convenience, does not depend on parser class.
  */
  public static class yyException extends java.lang.Exception {
  	public yyException (String message)
  	{
  		super(message);
  	}
  }

  /** must be implemented by a scanner object to supply input to the parser.
      Nested for convenience, does not depend on parser class.
  */
  public interface yyInput {

  	/** move on to next token.
  	    @return <tt>false</tt> if positioned beyond tokens.
  	    @throws IOException on input error.
  	*/
  	boolean advance () throws java.io.IOException, SDMSException;

  	/** classifies current token.
  	    Should not be called if {@link #advance()} returned <tt>false</tt>.
  	    @return current <tt>%token</tt> or single character.
  	*/
  	int token ();

  	/** associated with current token.
  	    Should not be called if {@link #advance()} returned <tt>false</tt>.
  	    @return value for {@link #token()}.
  	*/
  	Object value ();
  }

  /** simplified error message.
      @see #yyerror(java.lang.String, java.lang.String[])
  */
  public void yyerror (String message) {
  	yyerror(message, null);
  }

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected list of acceptable tokens, if available.
  */
  public void yyerror (String message, String[] expected)
  {
  	if (expected != null && expected.length > 0) {
  		System.err.print(message+", expecting");
  		for (int n = 0; n < expected.length; ++ n)
  			System.err.print(" "+expected[n]);
  		System.err.println();
  	} else
  		System.err.println(message);
  }

  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
  */
  protected String[] yyExpecting (int state)
  {
  	int token, n, len = 0;
  	boolean[] ok = new boolean[yyNames.length];

  	if ((n = yySindex[state]) != 0)
  		for (token = n < 0 ? -n : 0;
  				 token < yyNames.length && n+token < yyTable.length; ++ token)
  			if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
  				++ len;
  				ok[token] = true;
  			}
  	if ((n = yyRindex[state]) != 0)
  		for (token = n < 0 ? -n : 0;
  				 token < yyNames.length && n+token < yyTable.length; ++ token)
  			if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
  				++ len;
  				ok[token] = true;
  			}

  	String result[] = new String[len];
  	for (n = token = 0; n < len;  ++ token)
  		if (ok[token]) result[n++] = yyNames[token];
  	return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a dynamic state and value stack.
      @param yyLex scanner.
      @param yydebug debug message writer implementing <tt>yyDebug</tt>, or <tt>null</tt>.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
  */
  public Object yyparse (yyInput yyLex, Object yydebug)
	throws java.io.IOException, yyException, SDMSException
  {
//t  	this.yydebug = (jay.yydebug.yyDebug)yydebug;
  	return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
  		This is not final so that it can be overwritten outside of invocations
  		of {@link #yyparse}.
  	*/
  protected int yyMax;

  /** executed at the beginning of a reduce action.
  		Used as <tt>$$ = yyDefault($1)</tt>, prior to the user-specified action, if any.
  		Can be overwritten to provide deep copy, etc.
  		@param first value for <tt>$1</tt>, or <tt>null</tt>.
  		@return first.
  	*/
  protected Object yyDefault (Object first)
  {
  	return first;
  }

  /** the generated parser.
  		Maintains a dynamic state and value stack.
  		@param yyLex scanner.
  		@return result of the last reduction, if any.
  		@throws yyException on irrecoverable parse error.
  	*/
  public Object yyparse (yyInput yyLex) throws java.io.IOException, yyException, SDMSException {
  	if (yyMax <= 0) yyMax = 256;			// initial size
  	int yyState = 0, yyStates[] = new int[yyMax];	// state stack
  	Object yyVal = null, yyVals[] = new Object[yyMax];	// value stack
  	int yyToken = -1;					// current input
  	int yyErrorFlag = 0;				// #tokens to shift

  	yyLoop:
  	for (int yyTop = 0;; ++ yyTop) {
  		if (yyTop >= yyStates.length) {			// dynamically increase
  			int[] i = new int[yyStates.length+yyMax];
  			System.arraycopy(yyStates, 0, i, 0, yyStates.length);
  			yyStates = i;
  			Object[] o = new Object[yyVals.length+yyMax];
  			System.arraycopy(yyVals, 0, o, 0, yyVals.length);
  			yyVals = o;
  		}
  		yyStates[yyTop] = yyState;
  		yyVals[yyTop] = yyVal;
//t  		if (yydebug != null) yydebug.push(yyState, yyVal);

  		yyDiscarded:
  		for (;;) {	// discarding a token does not change stack
  			int yyN;
  			if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
  				if (yyToken < 0) {
  					yyToken = yyLex.advance() ? yyLex.token() : 0;
//t  					if (yydebug != null)
//t  						yydebug.lex(yyState, yyToken, yyName(yyToken), yyLex.value());
  				}
  				if ((yyN = yySindex[yyState]) != 0 && (yyN += yyToken) >= 0
  						&& yyN < yyTable.length && yyCheck[yyN] == yyToken) {
//t  					if (yydebug != null)
//t  						yydebug.shift(yyState, yyTable[yyN], yyErrorFlag > 0 ? yyErrorFlag-1 : 0);
  					yyState = yyTable[yyN];		// shift to yyN
  					yyVal = yyLex.value();
  					yyToken = -1;
  					if (yyErrorFlag > 0) -- yyErrorFlag;
  					continue yyLoop;
  				}
  				if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
  						&& yyN < yyTable.length && yyCheck[yyN] == yyToken)
  					yyN = yyTable[yyN];			// reduce (yyN)
  				else
  					switch (yyErrorFlag) {
  
  					case 0:
  						yyerror("syntax error", yyExpecting(yyState));
//t  						if (yydebug != null) yydebug.error("syntax error");
  
  					case 1: case 2:
  						yyErrorFlag = 3;
  						do {
  							if ((yyN = yySindex[yyStates[yyTop]]) != 0
  									&& (yyN += yyErrorCode) >= 0 && yyN < yyTable.length
  									&& yyCheck[yyN] == yyErrorCode) {
//t  								if (yydebug != null)
//t  									yydebug.shift(yyStates[yyTop], yyTable[yyN], 3);
  								yyState = yyTable[yyN];
  								yyVal = yyLex.value();
  								continue yyLoop;
  							}
//t  							if (yydebug != null) yydebug.pop(yyStates[yyTop]);
  						} while (-- yyTop >= 0);
//t  						if (yydebug != null) yydebug.reject();
  						throw new yyException("irrecoverable syntax error");
  
  					case 3:
  						if (yyToken == 0) {
//t  							if (yydebug != null) yydebug.reject();
  							throw new yyException("irrecoverable syntax error at end-of-file");
  						}
//t  						if (yydebug != null)
//t  							yydebug.discard(yyState, yyToken, yyName(yyToken),
//t  							yyLex.value());
  						yyToken = -1;
  						continue yyDiscarded;		// leave stack alone
  					}
  			}
  			int yyV = yyTop + 1-yyLen[yyN];
//t  			if (yydebug != null)
//t  				yydebug.reduce(yyState, yyStates[yyV-1], yyN, yyRule[yyN], yyLen[yyN]);
  			yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
  			switch (yyN) {
case 1:
					// line 58 "MiniParser.jay"
  { /* Empty input is OK */ }
  break;
case 2:
					// line 59 "MiniParser.jay"
  { 
						  String stmt = ((String)yyVals[0+yyTop]).toString();
						  String ucStmt = stmt.toUpperCase();
						  if (ucStmt.startsWith("DUMP ")) {
							isDump = true;
						  } else {
						  	if (ucStmt.matches("^VERSION *[0-9][0-9]* *DUMP .*")) {
								isDump = true;
							} else {
								isDump = false;
							}
						  }
						  long bevor = System.currentTimeMillis();
						  SDMSOutput output = sc.execute(stmt); 
						  long after = System.currentTimeMillis();
						  if(printTime)
						  	out.println("Execution Time: " + (after - bevor));
						  if(printCmd)
						  	out.println(stmt);
						  bevor = after;
						  render(output);
						  after = System.currentTimeMillis();
						  if(printTime)
						  	out.println("\nRender Time   : " + (after - bevor));
						  /* stmtList.add(new StatementStackElement(STATEMENT, stmt));*/
						}
  break;
case 3:
					// line 85 "MiniParser.jay"
  { try {
							sc.finish();
						  } catch(IOException e) { /* ignore */ } 
						  if(stop == 0)
						  	System.exit(0);
						}
  break;
case 4:
					// line 91 "MiniParser.jay"
  { 
						  	SDMSOutput o = new SDMSOutput();
							o.setFeedback("End of Output");
							render(o);
						}
  break;
case 5:
					// line 96 "MiniParser.jay"
  { SDMSOutput o = new SDMSOutput(); 
						  o.setError(new SDMSOutputError("Desktop-0005", "File not found : " + ((String)yyVals[0+yyTop]).toString()));
						  render(o);
						}
  break;
case 6:
					// line 100 "MiniParser.jay"
  { SDMSOutput o = new SDMSOutput(); 
						  o.setError(new SDMSOutputError("Desktop-0006", "Invalid File Specification: "
											+ ((String)yyVals[0+yyTop]).toString() + " (missing quotes?)"));
						  render(o);
						}
  break;
case 7:
					// line 105 "MiniParser.jay"
  { final Runtime rt = Runtime.getRuntime();
						  	SDMSOutput o = new SDMSOutput();
							String cmdarr[] = new String[3];
							cmdarr[0] = "/bin/sh";
							cmdarr[1] = "-c";
							cmdarr[2] = ((String)yyVals[0+yyTop]);
						  
						  try {
						  	Process p = rt.exec(cmdarr);
						  	InputStream stdo = p.getInputStream();
							InputStream stde = p.getErrorStream();
							OutputStream stdi = p.getOutputStream();
							stdi.close();				/* we close input*/
							process_output(stdo, stde);
							o.setFeedback("End of Output");
						  } catch(final IOException ioe) {
							o.setError(new SDMSOutputError("Desktop-0006", "Couldn't start process : " +
									ioe.toString()));
						  }
						  render(o);
						  /* stmtList.add(new StatementStackElement(SHELLCMD, $2));*/
						}
  break;
case 8:
					// line 128 "MiniParser.jay"
  { /* do nothing */ }
  break;
case 9:
					// line 129 "MiniParser.jay"
  { 
						  String[] a = new String[1];
						  a[0] = "valid SDMS(h) command";
						  yyerror(S_SYNTAX_ERROR,a);
						}
  break;
case 10:
					// line 134 "MiniParser.jay"
  {
						  	SDMSOutput o = new SDMSOutput();
							help();
							o.setFeedback("End of Output");
							render(o);
						}
  break;
case 11:
					// line 140 "MiniParser.jay"
  {
						  	SDMSOutput o = new SDMSOutput();
							setPrintCmd();
							o.setFeedback("End of Output");
							render(o);
						}
  break;
case 12:
					// line 146 "MiniParser.jay"
  {
						  	SDMSOutput o = new SDMSOutput();
							resetPrintCmd();
							o.setFeedback("End of Output");
							render(o);
						}
  break;
case 13:
					// line 152 "MiniParser.jay"
  {
						  	SDMSOutput o = new SDMSOutput();
							setPrintTime();
							o.setFeedback("End of Output");
							render(o);
						}
  break;
case 14:
					// line 158 "MiniParser.jay"
  {
						  	SDMSOutput o = new SDMSOutput();
							resetPrintTime();
							o.setFeedback("End of Output");
							render(o);
						}
  break;
case 15:
					// line 164 "MiniParser.jay"
  {
						  	SDMSOutput o = new SDMSOutput();
							((SDMSLineRenderer) or).setPrompt(((String)yyVals[0+yyTop]));
							o.setFeedback("End of Output");
							render(o);
						}
  break;
case 16:
					// line 172 "MiniParser.jay"
  {	
						  long bevor = System.currentTimeMillis();
						  SDMSOutput output = sc.execute(((String)yyVals[-4+yyTop]) + "\n" + ((String)yyVals[-3+yyTop]) + "\n" + ((String)yyVals[-2+yyTop]) + ((String)yyVals[-1+yyTop]));
						  long after = System.currentTimeMillis();
						  if(printTime)
						  	out.println("Execution Time: " + (after - bevor));
						  if(printCmd)
						  	out.println(((String)yyVals[-4+yyTop]) + "\n" + ((String)yyVals[-3+yyTop]) + "\n" + ((String)yyVals[-2+yyTop]) + ((String)yyVals[-1+yyTop]));
						  bevor = after;
						  render(output);
						  after = System.currentTimeMillis();
						  if(printTime)
						  	out.println("\nRender Time   : " + (after - bevor));
						  /* stmtList.add(new StatementStackElement(STATEMENT, $1 + "\n" + $2 + "\n" + $3));*/
						}
  break;
case 17:
					// line 188 "MiniParser.jay"
  { yyVal = ";"; }
  break;
case 18:
					// line 189 "MiniParser.jay"
  { yyVal = " ROLLBACK;"; }
  break;
case 19:
					// line 191 "MiniParser.jay"
  { yyVal = renderPrompt(((String)yyVals[0+yyTop])); }
  break;
case 20:
					// line 193 "MiniParser.jay"
  { yyVal = ""; }
  break;
case 21:
					// line 194 "MiniParser.jay"
  { yyVal = ((String)yyVals[0+yyTop]); }
  break;
case 22:
					// line 196 "MiniParser.jay"
  { yyVal = ((String)yyVals[0+yyTop]); }
  break;
case 23:
					// line 197 "MiniParser.jay"
  { yyVal = ((String)yyVals[-1+yyTop]) + "\n" + ((String)yyVals[0+yyTop]); }
  break;
case 24:
					// line 199 "MiniParser.jay"
  { /* do nothing */ }
  break;
case 25:
					// line 201 "MiniParser.jay"
  { discOnError = true; retVal = ((Integer)yyVals[0+yyTop]).intValue(); }
  break;
case 26:
					// line 202 "MiniParser.jay"
  { discOnError = false; }
  break;
case 27:
					// line 204 "MiniParser.jay"
  { if(((Long)yyVals[0+yyTop]).longValue() <= Integer.MAX_VALUE)
						  	yyVal = Integer.valueOf (((Long)yyVals[0+yyTop]).intValue());
						  else {
							String[] a = new String[1];
							a[0] = "VALID INTEGER (Integer out of bounds)";
							yyerror(S_SYNTAX_ERROR, a);
							yyVal = ((Long)yyVals[0+yyTop]);
						  }
						}
  break;
case 28:
					// line 213 "MiniParser.jay"
  { 
							String[] a = new String[1];
							a[0] = "VALID INTEGER (Integer out of bounds)";
							yyerror(S_SYNTAX_ERROR, a);
							yyVal = ((Long)yyVals[0+yyTop]);
						}
  break;
case 29:
					// line 220 "MiniParser.jay"
  { /* do nothing */ }
  break;
case 30:
					// line 221 "MiniParser.jay"
  { /* do nothing */ }
  break;
case 31:
					// line 222 "MiniParser.jay"
  { /* do nothing */ }
  break;
case 32:
					// line 223 "MiniParser.jay"
  { /* do nothing */ }
  break;
case 33:
					// line 224 "MiniParser.jay"
  { /* do nothing */ }
  break;
case 34:
					// line 225 "MiniParser.jay"
  { /* do nothing */ }
  break;
					// line 756 "-"
  			}
  			yyTop -= yyLen[yyN];
  			yyState = yyStates[yyTop];
  			int yyM = yyLhs[yyN];
  			if (yyState == 0 && yyM == 0) {
//t  				if (yydebug != null) yydebug.shift(0, yyFinal);
  				yyState = yyFinal;
  				if (yyToken < 0) {
  					yyToken = yyLex.advance() ? yyLex.token() : 0;
//t  					if (yydebug != null)
//t  						 yydebug.lex(yyState, yyToken,yyName(yyToken), yyLex.value());
  				}
  				if (yyToken == 0) {
//t  					if (yydebug != null) yydebug.accept(yyVal);
  					return yyVal;
  				}
  				continue yyLoop;
  			}
  			if ((yyN = yyGindex[yyM]) != 0 && (yyN += yyState) >= 0
  					&& yyN < yyTable.length && yyCheck[yyN] == yyState)
  				yyState = yyTable[yyN];
  			else
  				yyState = yyDgoto[yyM];
//t  			if (yydebug != null) yydebug.shift(yyStates[yyTop], yyState);
  			continue yyLoop;
  		}
  	}
  }

					// line 227 "MiniParser.jay"

public void setServerConnection(SDMSServerConnection s)	{ sc = s; }
public void setPrintCmd(boolean verbose)		{ printCmd = verbose; }
public void setOutputRenderer(SDMSOutputRenderer r)	{ or = r; }
public SDMSOutputRenderer getOutputRenderer()		{ return or; }
public void setEnvInfo(String h, int p, String u)	{ host = h; port = "" + p; user = u; }


public void render(SDMSOutput o)
	throws SDMSException
{
	if (isDump && o.error == null) {
		String fn = (String) ((Vector) o.container.dataset.get(0)).get(1);
		if (fn != null) {
			try {
				PrintStream p = new PrintStream(new FileOutputStream(fn));
				p.print((String) ((Vector) o.container.dataset.get(0)).get(0));
				p.close();
				out.println("");
			} catch (IOException ioe) {
				out.println(ioe.toString() + "\n");
			}
		  	SDMSOutput oo = new SDMSOutput();
			oo.setFeedback("Dump to " + fn + " completed");
			or.render(out, oo);
		} else {
			or.render(out, o);
		}
		isDump = false;
	} else {
		or.render(out, o);
	}
	if(o.error != null) {
		if(discOnError || o.error.code.startsWith("Desktop")) {
			try {
				sc.finish();
			} catch(Exception e) {
				// ignore
			}
			out.println("");
			System.exit(retVal);
		}
	}
}

private String renderPrompt(String p)
{
	final int pl = p.length();
	char[] ap = new char[pl];
	p.getChars(0, pl, ap, 0);
	StringBuffer b = new StringBuffer();

	for (int i = 1; i < pl -1; ++i) {	// we skip the quotes
		if (ap[i] == '%') {
			++i;
			switch (ap[i]) {
				case 'H':
					b.append(host);
					break;
				case 'P':
					b.append(port);
					break;
				case 'U':
					b.append(user);
					break;
				case '%':
					b.append('%');
					break;
				default:
					b.append('%');
					b.append(ap[i]);
					break;
			}
		} else {
			b.append(ap[i]);
		}
	}

	return b.toString();
}

private void process_output(InputStream stdo, InputStream stde)
	throws IOException
{
	IOcatcher outC = new IOcatcher(stdo, out);
	IOcatcher errC = new IOcatcher(stde, System.err);
	outC.run();
	errC.run();
	while(true) {
		try {
			errC.join();
			break;
		} catch (InterruptedException e) {
			// ignore
		}
	}
	while(true) {
		try {
			outC.join();
			break;
		} catch (InterruptedException e) {
			// ignore
		}
	}
}

public static void setPrintTime()	{ printTime = true; }
public static void resetPrintTime()	{ printTime = false; }
public static void setPrintCmd()	{ printCmd = true; }
public static void resetPrintCmd()	{ printCmd = false; }

public void help()
{
	out.println("Condensed Help Feature");
	out.println("----------------------\n");
	out.println("Internal sdmsh Commands:");
	out.println("disconnect|bye|exit|quit         -- leaves the tool");
	out.println("echo on|off                      -- controls whether the statementtext is printed or not");
	out.println("help                             -- gives this output");
	out.println("include '<filespec>'             -- reads sdms(h) commands from the given file");
	out.println("prompt '<somestring>'            -- sets to prompt to the specified value");
	out.println("                                    %H = hostname, %P = port, %U = user, %% = %");
	out.println("timing on|off                    -- controls whether the actual time is printed or not");
	out.println("whenever error ");
	out.println("  continue|disconnect <integer>  -- specifies the behaviour of the program in case of an error");
	out.println("!<shellcommand>                  -- executes the specified command. sdmsh has no intelligence");
	out.println("                                    at all regarding terminal I/O");
}

public void setOutputStream(PrintStream out)
{
	this.out = out;
}

}

class IOcatcher extends Thread {

	BufferedReader br;
	PrintStream out;

	IOcatcher(InputStream i, PrintStream o)
	{
		br = new BufferedReader(new InputStreamReader(i));
		out = o;
	}

	public void run()
	{
		String text;

		try {
			while ((text = br.readLine()) != null) {
				out.println(text);
			}
		} catch (IOException ioe) {
			out.println(ioe.toString());
		}
	}

}

class StatementStackElement {

	public int type;
	public String text;
	
	StatementStackElement(int t, String txt) {
		type = t;
		text = txt;
	}
}
					// line 959 "-"
