/* The following code was generated by JFlex 1.7.0 */

//
// $Id: MiniScanner.jlex,v 2.10.4.1 2013/03/14 10:25:30 ronald Exp $
//
// Copyright (C) 2001 topIT Informationstechnologie GmbH
//
//
//
package de.independit.scheduler.shell;

import java.lang.*;
import java.util.*;
import java.io.*;

import de.independit.scheduler.server.SDMSConstants;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>MiniScanner.jlex</tt>
 */
public class MiniScanner implements de.independit.scheduler.shell.MiniParser.yyInput {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING = 2;
  public static final int COMMENT = 4;
  public static final int FILESPEC = 6;
  public static final int FSSTR = 8;
  public static final int SHELL = 10;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5, 5
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\10\0\1\6\1\41\1\2\1\4\1\4\1\3\22\0\1\41\1\37"+
    "\5\0\1\44\1\47\1\50\1\45\2\0\1\5\1\0\1\1\12\42"+
    "\1\0\1\51\5\0\1\35\1\22\1\12\1\7\1\15\1\31\1\30"+
    "\1\24\1\10\1\46\1\36\1\25\1\27\1\14\1\13\1\26\1\20"+
    "\1\34\1\11\1\16\1\21\1\33\1\32\1\17\1\23\1\46\1\0"+
    "\1\43\2\0\1\40\1\0\1\35\1\22\1\12\1\7\1\15\1\31"+
    "\1\30\1\24\1\10\1\46\1\36\1\25\1\27\1\14\1\13\1\26"+
    "\1\20\1\34\1\11\1\16\1\21\1\33\1\32\1\17\1\23\1\46"+
    "\12\0\1\4\u1fa2\0\1\4\1\4\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\udfe6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\2\1\2\2\1\1\1\2\14\1\1\3\1\2"+
    "\1\4\1\5\1\6\1\7\1\10\2\11\1\12\2\2"+
    "\1\13\4\14\1\15\2\16\1\17\1\20\1\21\1\2"+
    "\1\22\16\1\1\23\1\24\1\25\1\26\1\27\11\1"+
    "\1\30\10\1\2\0\3\1\1\31\6\1\3\0\1\32"+
    "\10\1\2\0\1\1\2\0\1\33\3\1\1\34\1\1"+
    "\1\35\5\0\3\1\1\36\1\37\3\0\1\40\1\41"+
    "\1\0\1\42\3\0\1\43\13\0\1\44\2\0\1\45";

  private static int [] zzUnpackAction() {
    int [] result = new int[158];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\52\0\124\0\176\0\250\0\322\0\374\0\u0126"+
    "\0\u0150\0\u017a\0\u01a4\0\u01ce\0\u01f8\0\u0222\0\u024c\0\u0276"+
    "\0\u02a0\0\u02ca\0\u02f4\0\u031e\0\u0348\0\u0372\0\u039c\0\u03c6"+
    "\0\u03f0\0\u041a\0\u0444\0\u03f0\0\u03f0\0\u03f0\0\u03f0\0\u046e"+
    "\0\u0498\0\u03f0\0\u04c2\0\u04ec\0\u0516\0\u0540\0\u056a\0\u0594"+
    "\0\u05be\0\u03f0\0\u05e8\0\u0612\0\u03f0\0\u063c\0\u03f0\0\u0666"+
    "\0\u03f0\0\u0690\0\u06ba\0\u06e4\0\u070e\0\u0738\0\u0762\0\u078c"+
    "\0\u07b6\0\u07e0\0\u080a\0\u0834\0\u085e\0\u0888\0\u08b2\0\u03f0"+
    "\0\u03f0\0\u03f0\0\u03f0\0\u03f0\0\u08dc\0\u0906\0\u0930\0\u095a"+
    "\0\u0984\0\u09ae\0\u09d8\0\u0a02\0\u0a2c\0\u024c\0\u0a56\0\u0a80"+
    "\0\u0aaa\0\u0ad4\0\u0afe\0\u0b28\0\u0b52\0\u0b7c\0\u0ba6\0\u0bd0"+
    "\0\u0bfa\0\u0c24\0\u0c4e\0\u024c\0\u0c78\0\u0ca2\0\u0ccc\0\u0cf6"+
    "\0\u0d20\0\u0d4a\0\u0d74\0\u0d9e\0\u0dc8\0\u024c\0\u0df2\0\u0e1c"+
    "\0\u0e46\0\u0e70\0\u0e9a\0\u0ec4\0\u0eee\0\u0f18\0\u0f42\0\u0f6c"+
    "\0\u0f96\0\u0fc0\0\u0fea\0\u024c\0\u1014\0\u103e\0\u1068\0\u024c"+
    "\0\u1092\0\u03f0\0\u10bc\0\u10e6\0\u1110\0\u113a\0\u1164\0\u118e"+
    "\0\u11b8\0\u11e2\0\u024c\0\u03f0\0\u120c\0\u1236\0\u1260\0\u024c"+
    "\0\u024c\0\u128a\0\u03f0\0\u12b4\0\u12de\0\u1308\0\u03f0\0\u1332"+
    "\0\u135c\0\u1386\0\u13b0\0\u13da\0\u1404\0\u142e\0\u1458\0\u1482"+
    "\0\u14ac\0\u14d6\0\u03f0\0\u1500\0\u152a\0\u03f0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[158];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\1\10\1\11\1\12\1\7\1\13\1\14\1\15"+
    "\1\16\1\17\1\20\2\17\1\21\1\22\1\17\1\23"+
    "\1\17\1\24\1\17\1\25\1\17\1\26\3\17\1\27"+
    "\1\17\1\30\2\17\1\31\1\7\1\32\1\33\1\7"+
    "\1\34\1\7\1\17\1\35\1\36\1\37\43\40\1\41"+
    "\1\42\5\40\45\43\1\44\4\43\2\45\1\46\1\47"+
    "\2\45\1\50\32\45\1\51\2\45\1\52\5\45\43\53"+
    "\1\54\1\55\5\53\2\56\2\57\1\0\45\56\1\7"+
    "\1\0\3\7\1\0\1\7\31\0\1\7\2\0\1\7"+
    "\1\0\1\7\5\0\1\60\43\0\1\61\4\0\1\7"+
    "\1\0\2\11\1\7\1\0\1\7\31\0\1\7\2\0"+
    "\1\7\1\0\1\7\4\0\1\7\1\0\1\11\1\12"+
    "\1\7\1\0\1\14\31\0\1\7\1\32\1\0\1\7"+
    "\1\0\1\7\11\0\1\60\44\0\1\7\1\0\1\7"+
    "\1\14\1\7\1\0\1\14\31\0\1\7\1\32\1\0"+
    "\1\7\1\0\1\7\13\0\1\17\1\62\26\17\7\0"+
    "\1\17\12\0\5\17\1\63\22\17\7\0\1\17\12\0"+
    "\30\17\7\0\1\17\12\0\4\17\1\64\23\17\7\0"+
    "\1\17\12\0\3\17\1\65\1\17\1\66\2\17\1\67"+
    "\14\17\1\70\2\17\7\0\1\17\12\0\1\17\1\71"+
    "\26\17\7\0\1\17\12\0\12\17\1\67\15\17\7\0"+
    "\1\17\12\0\6\17\1\72\5\17\1\73\13\17\7\0"+
    "\1\17\12\0\6\17\1\74\21\17\7\0\1\17\12\0"+
    "\25\17\1\75\2\17\7\0\1\17\12\0\15\17\1\76"+
    "\12\17\7\0\1\17\12\0\4\17\1\77\23\17\7\0"+
    "\1\17\60\0\1\32\2\0\1\32\32\0\1\32\52\0"+
    "\1\33\7\0\43\40\2\0\5\40\43\0\1\100\1\101"+
    "\5\0\45\43\1\0\4\43\1\0\1\102\50\0\2\45"+
    "\2\0\35\45\1\0\2\45\1\0\5\45\2\0\2\46"+
    "\50\0\1\46\1\47\2\0\1\51\32\0\1\51\10\0"+
    "\2\45\1\0\1\51\2\45\1\50\32\45\1\51\2\45"+
    "\1\0\5\45\3\0\1\51\2\0\1\51\32\0\1\51"+
    "\10\0\43\53\2\0\5\53\43\0\1\103\1\104\5\0"+
    "\2\56\3\0\45\56\2\60\3\0\45\60\7\0\2\17"+
    "\1\105\25\17\7\0\1\17\12\0\3\17\1\106\24\17"+
    "\7\0\1\17\12\0\5\17\1\107\22\17\7\0\1\17"+
    "\12\0\15\17\1\110\12\17\7\0\1\17\12\0\1\111"+
    "\27\17\7\0\1\17\12\0\1\17\1\112\26\17\7\0"+
    "\1\17\12\0\25\17\1\113\2\17\7\0\1\17\12\0"+
    "\20\17\1\114\7\17\7\0\1\17\12\0\21\17\1\115"+
    "\6\17\7\0\1\17\12\0\6\17\1\116\21\17\7\0"+
    "\1\17\12\0\16\17\1\117\11\17\7\0\1\17\12\0"+
    "\4\17\1\120\23\17\7\0\1\17\12\0\6\17\1\121"+
    "\21\17\7\0\1\17\12\0\16\17\1\122\11\17\7\0"+
    "\1\17\12\0\3\17\1\123\24\17\7\0\1\17\12\0"+
    "\16\17\1\124\11\17\7\0\1\17\12\0\7\17\1\125"+
    "\20\17\7\0\1\17\12\0\4\17\1\126\23\17\7\0"+
    "\1\17\5\0\2\127\3\0\30\17\1\0\1\130\1\127"+
    "\4\0\1\17\12\0\7\17\1\116\20\17\7\0\1\17"+
    "\12\0\4\17\1\131\23\17\7\0\1\17\12\0\1\17"+
    "\1\132\26\17\7\0\1\17\12\0\1\17\1\133\26\17"+
    "\7\0\1\17\12\0\17\17\1\134\10\17\7\0\1\17"+
    "\12\0\20\17\1\135\7\17\7\0\1\17\12\0\5\17"+
    "\1\136\22\17\7\0\1\17\12\0\16\17\1\137\11\17"+
    "\7\0\1\17\12\0\4\17\1\140\23\17\7\0\1\17"+
    "\12\0\12\17\1\141\15\17\7\0\1\17\12\0\1\17"+
    "\1\142\26\17\7\0\1\17\5\0\2\143\3\0\30\17"+
    "\1\0\1\144\1\143\4\0\1\17\5\0\2\127\23\0"+
    "\1\145\11\0\1\127\37\0\1\145\31\0\25\17\1\146"+
    "\2\17\7\0\1\17\12\0\5\17\1\147\22\17\7\0"+
    "\1\17\12\0\5\17\1\150\22\17\7\0\1\17\12\0"+
    "\17\17\1\151\10\17\7\0\1\17\12\0\6\17\1\152"+
    "\21\17\7\0\1\17\12\0\13\17\1\153\14\17\7\0"+
    "\1\17\12\0\5\17\1\154\22\17\7\0\1\17\12\0"+
    "\1\155\27\17\7\0\1\17\12\0\5\17\1\156\22\17"+
    "\7\0\1\17\5\0\2\143\7\0\1\157\25\0\1\143"+
    "\23\0\1\157\57\0\1\160\37\0\21\17\1\161\6\17"+
    "\7\0\1\17\5\0\2\162\3\0\30\17\1\0\1\163"+
    "\1\162\4\0\1\17\12\0\7\17\1\164\20\17\7\0"+
    "\1\17\12\0\24\17\1\165\3\17\7\0\1\17\12\0"+
    "\26\17\1\166\1\17\7\0\1\17\12\0\5\17\1\167"+
    "\22\17\7\0\1\17\12\0\6\17\1\170\21\17\7\0"+
    "\1\17\12\0\12\17\1\171\15\17\7\0\1\17\17\0"+
    "\1\172\14\0\1\173\45\0\1\174\26\0\2\175\3\0"+
    "\30\17\1\0\1\176\1\175\4\0\1\17\5\0\2\162"+
    "\23\0\1\177\11\0\1\162\37\0\1\177\31\0\6\17"+
    "\1\200\21\17\7\0\1\17\12\0\3\17\1\201\24\17"+
    "\7\0\1\17\12\0\6\17\1\202\21\17\7\0\1\17"+
    "\12\0\6\17\1\203\21\17\7\0\1\17\34\0\1\204"+
    "\36\0\1\205\35\0\2\175\7\0\1\206\25\0\1\175"+
    "\23\0\1\206\57\0\1\207\37\0\25\17\1\210\2\17"+
    "\7\0\1\17\12\0\27\17\1\211\7\0\1\17\12\0"+
    "\3\17\1\112\24\17\7\0\1\17\13\0\1\212\55\0"+
    "\1\213\14\0\1\214\45\0\1\215\36\0\1\216\70\0"+
    "\1\217\36\0\1\220\46\0\1\221\46\0\1\222\70\0"+
    "\1\223\34\0\1\224\66\0\1\225\35\0\1\226\73\0"+
    "\1\227\43\0\1\230\36\0\1\231\64\0\1\232\31\0"+
    "\1\233\77\0\1\234\30\0\1\235\44\0\1\236\42\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[5460];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\22\1\1\11\2\1\4\11\2\1\1\11\7\1"+
    "\1\11\2\1\1\11\1\1\1\11\1\1\1\11\16\1"+
    "\5\11\22\1\2\0\12\1\3\0\11\1\2\0\1\1"+
    "\2\0\6\1\1\11\5\0\4\1\1\11\3\0\2\1"+
    "\1\0\1\11\3\0\1\11\13\0\1\11\2\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[158];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;
  
  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** the stack of open (nested) input streams to read from */
  private java.util.Stack<ZzFlexStreamInfo> zzStreams
    = new java.util.Stack<ZzFlexStreamInfo>();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private static final class ZzFlexStreamInfo {
    java.io.Reader zzReader;
    int zzEndRead;
    int zzStartRead;
    int zzCurrentPos;
    int zzMarkedPos;
    int yyline;
    int yychar;
    int yycolumn;
    char [] zzBuffer;
    boolean zzAtBOL;
    boolean zzAtEOF;
    boolean zzEOFDone;
    int zzFinalHighSurrogate;

    /** sets all values stored in this class */
    ZzFlexStreamInfo(java.io.Reader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, char [] zzBuffer, 
                  boolean zzAtBOL, boolean zzAtEOF, boolean zzEOFDone,
                  int zzFinalHighSurrogate, int yyline, int yychar, int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtBOL       = zzAtBOL;
      this.zzAtEOF       = zzAtEOF;
      this.zzEOFDone     = zzEOFDone;
      this.zzFinalHighSurrogate = zzFinalHighSurrogate;
      this.yyline        = yyline;
      this.yychar        = yychar;
      this.yycolumn      = yycolumn;
    }
  }

  /* user code: */
private static boolean debug = false;
private boolean inStatement  = false;
private boolean inMultiCmd   = false;
private boolean eatSemiColon = false;

public int yyline()
{
	return yyline + 1;
}

private int token;
private int pos = 0;
private int brctr = 0;
private Object value = new String("");
private Vector dirStack = new Vector();

public boolean advance() throws java.io.IOException
{
	value = new String("");
	token = yylex();
	return (token != YYEOF);
}

public int token()
{
	return token;
}

public Object value() 
{
	if (value instanceof StringBuffer) return value.toString();
	return value;
}

public int pos()
{
	return pos;
}

private void addVal()
{
	if (value instanceof StringBuffer) {
		((StringBuffer) value).append(yytext());
	} else {
		value = new StringBuffer(value.toString() + yytext());
	}
	pos += yytext().length();
}

private void addVal(String s)
{
	if (!(value instanceof StringBuffer)) {
		value = new StringBuffer(value.toString());
	}
	((StringBuffer) value).append(s);
	pos += s.length();
}

private void startInclude(File f)
{
	// push directory
	try {
		File g = f.getAbsoluteFile().getParentFile();
		dirStack.add(g.getCanonicalPath());
	} catch(Exception e) {
		// do nothing
		System.out.println("ERROR: Exception in stack bookkeeping : " + e.toString());
		Runtime.getRuntime().halt(1);
	}
}

private void endInclude()
{
	// pop directory
	dirStack.remove(dirStack.size() - 1);
}



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public MiniScanner(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 204) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    // unlikely but not impossible: read 0 characters, but not at end of stream
    if (numRead == 0) {
      numRead = zzReader.read(zzBuffer, zzEndRead, requested);
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (numRead == requested) { /* possibly more input available */
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      return false;
    }

    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopStream (usually in an <<EOF>> action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public final void yypushStream(java.io.Reader reader) {
    zzStreams.push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzBuffer, zzAtBOL, zzAtEOF, zzEOFDone,
                        zzFinalHighSurrogate, yyline, yychar, yycolumn)
    );
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzBuffer = new char[ZZ_BUFFERSIZE];
    zzReader = reader;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
  }
    

  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack. 
   *
   * @throws java.util.EmptyStackException
   *         if there is no further stream to read from.
   *
   * @throws java.io.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(java.io.Reader)
   */
  public final void yypopStream() throws java.io.IOException {
    zzReader.close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos;
    zzAtBOL       = s.zzAtBOL;
    zzAtEOF       = s.zzAtEOF;
    zzEOFDone     = s.zzEOFDone;
    zzFinalHighSurrogate = s.zzFinalHighSurrogate;
    yyline        = s.yyline;
    yychar        = s.yychar;
    yycolumn      = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left 
   * to read from on the stream stack.
   */
  public final boolean yymoreStreams() {
    return !zzStreams.isEmpty();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   *
   * @see #yypushStream(java.io.Reader)
   * @see #yypopStream()
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;
      char [] zzCMapL = ZZ_CMAP;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + (((zzInput >= 0) && (zzInput < zzCMapL.length)) ? zzCMapL[zzInput] : 0) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                if(yymoreStreams()) { endInclude(); yypopStream(); } else return YYEOF;
				  /* break; not necessary here because of fallthrough of default rule that ends the switch */
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { addVal();		inStatement = true;			break;
            } 
            // fall through
          case 38: break;
          case 2: 
            { if(inStatement) addVal();					break;
            } 
            // fall through
          case 39: break;
          case 3: 
            { if(!inStatement) { value = new String(""); yybegin(SHELL); } else addVal(); break;
            } 
            // fall through
          case 40: break;
          case 4: 
            { if(!inStatement) {
					try {
						value = Long.valueOf(yytext());
					} catch (NumberFormatException nfe) {
						value = SDMSConstants.lZERO;
				  		// System.out.print("NAN ");
						return MiniParser.NAN;
					}
				  	// System.out.print("INTEGER ");
					return MiniParser.INTEGER;
				  }
				  addVal();							break;
            } 
            // fall through
          case 41: break;
          case 5: 
            { addVal("'");				yybegin(STRING); 	break;
            } 
            // fall through
          case 42: break;
          case 6: 
            { addVal();		brctr++;				break;
            } 
            // fall through
          case 43: break;
          case 7: 
            { addVal();		brctr--;				break;
            } 
            // fall through
          case 44: break;
          case 8: 
            { // System.out.print("STATEMENT ");
				  if(!inMultiCmd) {
					addVal(";");
					if (brctr != 0) {
						break;
					}
					inStatement = false;
				  	return MiniParser.STATEMENT;
				  } else {
					if (eatSemiColon) {
						eatSemiColon = false;
						inMultiCmd = false;
						inStatement = false;
						return MiniParser.EOS;
					} else {
						addVal(";");
				  		return MiniParser.STATEMENT;
					}
				  }
            } 
            // fall through
          case 45: break;
          case 9: 
            { addVal();		break;
            } 
            // fall through
          case 46: break;
          case 10: 
            { addVal("'");		yybegin(YYINITIAL); if (!inStatement) return MiniParser.STRING; break;
            } 
            // fall through
          case 47: break;
          case 11: 
            { addVal();
				  // System.out.print("INVALIDFILE ");
				  return MiniParser.INVALIDFILE;
            } 
            // fall through
          case 48: break;
          case 12: 
            { /* do nothing */						break;
            } 
            // fall through
          case 49: break;
          case 13: 
            { yybegin(FSSTR);	value = new String("");			break;
            } 
            // fall through
          case 50: break;
          case 14: 
            { addVal();							break;
            } 
            // fall through
          case 51: break;
          case 15: 
            { yybegin(YYINITIAL);
				  String filename = value.toString();
				  File fname = new File(filename);
				  if(fname.isAbsolute()) {
					// absolute path -> don't prepend
					// System.out.println("(absolut) fname : " + fname.toString());
				  } else {
					// relative path -> prepend oldpath
					fname = new File(
						dirStack.size() > 0 ? 
							((String) dirStack.get(dirStack.size() - 1)) + File.separatorChar + filename :
							filename
						);
					// System.out.println("(relativ) fname : " + fname.toString());
				  }
				  startInclude(fname);
				  try {
					FileReader f = new FileReader(fname);
				  	yypushStream(f);
				  } catch (FileNotFoundException ffe) {
					// System.out.println("FILENOTFOUND ");
					return MiniParser.FILENOTFOUND;
				  }
				  value = new String("");
				  break;
            } 
            // fall through
          case 52: break;
          case 16: 
            { addVal(); break;
            } 
            // fall through
          case 53: break;
          case 17: 
            { yybegin(YYINITIAL);
				  // System.out.println("SHELLCMD ");
				  return MiniParser.SHELLCMD;
            } 
            // fall through
          case 54: break;
          case 18: 
            { if(inStatement) addVal();		yybegin(COMMENT); 	break;
            } 
            // fall through
          case 55: break;
          case 19: 
            { addVal("\\\\");	break;
            } 
            // fall through
          case 56: break;
          case 20: 
            { addVal("\\'");	break;
            } 
            // fall through
          case 57: break;
          case 21: 
            { if(inStatement) addVal();		 yybegin(YYINITIAL);	break;
            } 
            // fall through
          case 58: break;
          case 22: 
            { addVal("\\\\");						break;
            } 
            // fall through
          case 59: break;
          case 23: 
            { addVal("\\'");						break;
            } 
            // fall through
          case 60: break;
          case 24: 
            { if(!inStatement) { 
					// System.out.print("DISCONNECT ");
					return MiniParser.DISCONNECT;
				  } else addVal();
				  break;
            } 
            // fall through
          case 61: break;
          case 25: 
            { if(!inStatement) { return MiniParser.HELP; }		else    addVal(); break;
            } 
            // fall through
          case 62: break;
          case 26: 
            { if(!inStatement) {
					// System.out.print("S_ERROR ");
					return MiniParser.S_ERROR;
				  } else addVal();
				  break;
            } 
            // fall through
          case 63: break;
          case 27: 
            { if(!inStatement) { return MiniParser.PROMPT; }	else    addVal(); break;
            } 
            // fall through
          case 64: break;
          case 28: 
            { if(!inStatement) yybegin(FILESPEC);			else	addVal(); break;
            } 
            // fall through
          case 65: break;
          case 29: 
            { if(!inStatement) { return MiniParser.ECHOON; }	else	addVal(); break;
            } 
            // fall through
          case 66: break;
          case 30: 
            { if(!inStatement) {
					// System.out.print("CONTINUE ");
					return MiniParser.CONTINUE;
				  } else addVal();
				  break;
            } 
            // fall through
          case 67: break;
          case 31: 
            { if(!inStatement) { return MiniParser.ECHOOFF; }	else	addVal(); break;
            } 
            // fall through
          case 68: break;
          case 32: 
            { if(!inStatement) {
					// System.out.print("WHENEVER ");
					return MiniParser.WHENEVER;
				  } else addVal();
				  break;
            } 
            // fall through
          case 69: break;
          case 33: 
            { addVal();
				  if (inMultiCmd)
				  	eatSemiColon = true;
				  inStatement = true;
				  return MiniParser.ROLLBACK;
            } 
            // fall through
          case 70: break;
          case 34: 
            { if(!inStatement) { return MiniParser.TIMINGON; }	else	addVal(); break;
            } 
            // fall through
          case 71: break;
          case 35: 
            { if(!inStatement) { return MiniParser.TIMINGOFF; }	else	addVal(); break;
            } 
            // fall through
          case 72: break;
          case 36: 
            { if (inStatement) {
					addVal(";");
					inStatement = false;
					yypushback(((String) yytext()).length());	// so etwas muss es sein
					return MiniParser.STATEMENT;
				  }
				  addVal();
				  eatSemiColon = true;
				  // System.out.print("EMULTI ");
				  return MiniParser.EMULTI;
            } 
            // fall through
          case 73: break;
          case 37: 
            { addVal();
				  inStatement = true;
				  inMultiCmd = true;
				  // System.out.print("BMULTI ");
				  return MiniParser.BMULTI;
            } 
            // fall through
          case 74: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
