@ECHO OFF
REM
REM This batch file will set (and overwrite) some environment variables when
REM called directly from the commandline or from a batch file.
REM The environment variable ERRORLEVEL is set in in this case.
REM
REM When called using '%COMSPEC% /C RUN_JOBSERVER.BAT ...' the environment will not be changed.
REM On older Windows Systems like Windows95 and Windows98 the errorlevel cannot
REM be checked after calling this batch file in this case.  
REM

REM
REM Setting Parameters
REM
SET CONFIGFILE=
IF [%1]==[] GOTO NOCONFIG
SET CONFIGFILE=%1
SHIFT
GOTO ENDCONFIG
:NOCONFIG
ECHO Missing parameter configfile
GOTO PRINTUSAGE
:ENDCONFIG

SET ENVCLAUSE=
IF [%1]==[] GOTO ENDENV
IF [%1]==[-e] GOTO HAVEENV
ECHO Invalid parameter %1
GOTO PRINTUSAGE
:HAVEENV
SHIFT
IF [%1]==[] GOTO NOENV
SET ENVCLAUSE=-e %1
GOTO ENDENV
:NOENV
ECHO Missing parameter environmentfile
GOTO PRINTUSAGE
:ENDENV

CALL COMMON.BAT
IF [%ERRORLEVEL%]==[0] GOTO PASTCOMMON
SET BICSUITE_BATCH_EXITCODE=%ERRORLEVEL%
GOTO DOEXIT
:PASTCOMMON

SET INFO=jobserver[%WIN_VERSION%]
IF [%WIN_VERSION%]==[WIN_9X] GOTO PASTINFO
FOR /F "tokens=1*" %%i IN ('hostname') DO @set HOSTNAME=%%i
SET INFO=jobserver[%USERNAME%@%HOSTNAME%]
:PASTINFO
SET BICSUITE_BATCH_EXITCODE=0
SET ERRORLEVEL=
REM
REM run the jobserver
REM
"%BICSUITEJAVA_JS%" %BICSUITEJAVAFLAGS_JS% -cp "%BICSUITEHOME%\lib\BICsuite.jar" de.independit.scheduler.jobserver.JobServer %CONFIGFILE% "%INFO%" %ENVCLAUSE%
IF ERRORLEVEL 1 SET BICSUITE_BATCH_EXITCODE=1
GOTO DOEXIT

:PRINTUSAGE
ECHO usage: RUN_JOBSERVER configfile [-e environmentfile]
BICSUITE_BATCH_EXITCODE=1

:DOEXIT
REM
REM Exit depending on windows version
REM
IF [%WIN_VERSION%]==[WIN_NT] EXIT /B %BICSUITE_BATCH_EXITCODE% >NUL
SET ERRORLEVEL=%BICSUITE_BATCH_EXITCODE%
