@ECHO OFF
REM
REM Setup BICsuite environment
REM
IF ["%BICSUITEHOME%"]==[""] GOTO UNDEFINED_BICSUITEHOME
IF ["%BICSUITECONFIG%"]==[""] SET BICSUITECONFIG=%BICSUITEHOME%\etc

REM
REM Detecting windows version
REM
IF EXIST "%TEMP%\bicsuite_windows_version.txt" GOTO DOFIND
ver > "%TEMP%\bicsuite_windows_version.txt"
:DOFIND
FIND "Windows 9" "%TEMP%\bicsuite_windows_version.txt" > NUL
if errorlevel 1 GOTO WIN_NT
SET WIN_VERSION=WIN_9X
GOTO VERSION_SET

:WIN_NT
SET WIN_VERSION=WIN_NT

:VERSION_SET

CALL "%BICSUITECONFIG%\JAVA_CONF.BAT"
IF [%ERRORLEVEL%]==[0] GOTO JAVA_CONF_OK
GOTO BAD_JAVA_CONF
:JAVA_CONF_OK

CALL "%BICSUITECONFIG%\BICSUITE_CONF.BAT"
IF [%ERRORLEVEL%]==[0] GOTO BICSUITE_CONF_OK
GOTO BAD_BICSUITE_CONF
:BICSUITE_CONF_OK

SET BICSUITE_BATCH_EXITCODE=0
GOTO DOEXIT

:UNDEFINED_BICSUITEHOME
ECHO Environment Variable BICSUITEHOME must be defined
SET BICSUITE_BATCH_EXITCOD=1
GOTO DOEXIT

:BAD_JAVA_CONF
ECHO Missing or invalid file %BICSUITECONFIG%\JAVA_CONF.BAT
SET BICSUITE_BATCH_EXITCOD=1
GOTO DOEXIT

:DOEXIT
REM
REM Exit depending on windows version
REM
IF [%WIN_VERSION%]==[WIN_NT] EXIT /B %BICSUITE_BATCH_EXITCODE% >NUL
SET ERRORLEVEL=%BICSUITE_BATCH_EXITCODE%
