@echo off

rem 
rem Usage: jsctl command serviceName [ConfigFile]
rem

if "%2"=="" goto usage

rem ---------------------------------------------------------------------
rem
rem      SETUP BICSUITE ENVIRONMENT
rem
rem ---------------------------------------------------------------------
if not defined BICSUITEHOME goto undefined_bicsuitehome
if not defined BICSUITECONFIG set BICSUITECONFIG=%BICSUITEHOME%\etc

call "%BICSUITECONFIG%\JAVA_CONF.BAT"
if not %ERRORLEVEL% EQU 0 goto bad_java_conf

call "%BICSUITECONFIG%\BICSUITE_CONF.BAT"
if not %ERRORLEVEL% EQU 0 goto bad_bicsuite_conf


rem ---------------------------------------------------------------------
rem
rem      SET SOME VARIABLES
rem
rem ---------------------------------------------------------------------
set SRVNAME=%2
set CFGFILE=%3
set "CFGFILE=%CFGFILE:"=%"
set SRVEXEC=\"%BICSUITEHOME%\bin\Scrolllog.exe\"
set LOGDIR=%BICSUITELOGDIR%
if "%LOGDIR%"=="" set LOGDIR=%BICSUITEHOME%\log
set LOGNAME=%SRVNAME%
set SCRLLOG=%SRVNAME%.log
set WRKDIR=%BICSUITEHOME%
set SRVCMD=\"%BICSUITEJAVA_JS_SERVICE%\" %BICSUITEJAVAFLAGS_JS% -cp \"%BICSUITEHOME%\lib\BICsuite.jar\" de.independit.scheduler.jobserver.JobServer \"%CFGFILE%\"
set SRVPARM=-c %SRVNAME% \"%LOGDIR%\%LOGNAME%\" -o \"%LOGDIR%\%SCRLLOG%\" -e %SRVCMD%
set SRVSTART=auto


rem ---------------------------------------------------------------------
rem
rem      OH GREAT MASTER, WHAT IS YOUR WISH?
rem
rem ---------------------------------------------------------------------
if "%1"=="install" goto install
if "%1"=="remove" goto remove
if "%1"=="delete" goto remove
if "%1"=="start" goto start
if "%1"=="stop" goto stop
if "%1"=="status" goto status
if "%1"=="reconfigure" goto reconfigure
goto usage

rem ---------------------------------------------------------------------
rem
rem      DELETE/REMOVE THE SERVICE
rem
rem ---------------------------------------------------------------------
:remove
sc.exe delete %SRVNAME%
exit /B %ERRORLEVEL%


rem ---------------------------------------------------------------------
rem
rem      INSTALL THE SERVICE
rem
rem ---------------------------------------------------------------------
:install
if "%3"=="" goto usage
sc.exe create %SRVNAME% start= %SRVSTART% binpath= "%SRVEXEC% %SRVPARM%"
exit /B %ERRORLEVEL%


rem ---------------------------------------------------------------------
rem
rem      RECONFIGURE THE SERVICE
rem
rem ---------------------------------------------------------------------
:reconfigure
if "%3"=="" goto usage
sc.exe query %SRVNAME% | find "RUNNING" >NUL
if not errorlevel 1 goto reconfigure_end

sc.exe config %SRVNAME% start= %SRVSTART% binpath= "%SRVEXEC% %SRVPARM%"
exit /B %ERRORLEVEL%
:reconfigure_end
echo It seems the service is still running. Stop it first
exit /B 1


rem ---------------------------------------------------------------------
rem
rem      START THE SERVICE
rem
rem ---------------------------------------------------------------------
:start
rem is Jobserver already running?
sc.exe query %SRVNAME% | find "RUNNING" >NUL
if not errorlevel 1 goto start_end
sc.exe start %SRVNAME%
exit /B %ERRORLEVEL%
:start_end
echo Jobserver is already running
exit /B 1


rem ---------------------------------------------------------------------
rem
rem      STOP THE SERVICE
rem
rem ---------------------------------------------------------------------
:stop
rem we need the config file for the name of the jobserver
if "%3"=="" goto usage
rem is Jobserver running in the first place?
sc.exe query %SRVNAME% | find "RUNNING" >NUL
if errorlevel 1 goto stop_end

rem try a graceful shutdown first
if exist %HOMEDRIVE%%HOMEPATH%\.sdmshrc %BICSUITEHOME%\bin\shutdownjs %3; | %BICSUITEHOME%\bin\SDMSH.BAT >NUL
rem wait a moment for process to terminate
%BICSUITEHOME%\bin\SLEEP.EXE 10

rem check if still running; if not then success
sc.exe query %SRVNAME% | find "RUNNING" >NUL
if errorlevel 1 goto stop_end 

rem try to shutdown service 
sc.exe stop %SRVNAME%
exit /B %ERRORLEVEL%

:stop_end
exit /B 0


rem ---------------------------------------------------------------------
rem
rem      GET THE STATUS OF THE SERVICE
rem
rem ---------------------------------------------------------------------
:status
sc.exe query %SRVNAME%
exit /B 0


rem ---------------------------------------------------------------------
rem
rem      SOME ERROR EXITS
rem
rem ---------------------------------------------------------------------
:undefined_bicsuitehome
ECHO Environment Variable BICSUITEHOME must be defined
exit /B 1

:bad_java_conf
ECHO Missing or invalid file %BICSUITECONFIG%\JAVA_CONF.BAT
exit /B 1

:bad_bicsuite_conf
ECHO Missing or invalid file %BICSUITECONFIG%\BICSUITE_CONF.BAT
exit /B 1

:usage
echo "Usage: jsctl.bat install|remove|start|stop|status|reconfigure serviceName [configfile]"
echo . 
echo if the command is install, stop or reconfigure the configfile is a mandatory parameter
exit /B 1
